VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmErrorDisplay 
   BorderStyle     =   3  'Fixed Dialog
   ClientHeight    =   3615
   ClientLeft      =   1215
   ClientTop       =   1440
   ClientWidth     =   7560
   ControlBox      =   0   'False
   Icon            =   "ErrorDisplay.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   NegotiateMenus  =   0   'False
   ScaleHeight     =   241
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   504
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdPrinterSetup 
      Caption         =   "Printer Setup..."
      Height          =   435
      Left            =   3240
      TabIndex        =   7
      Top             =   3120
      Width           =   1350
   End
   Begin MSComDlg.CommonDialog dlgCommonDialog 
      Left            =   900
      Top             =   5760
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.PictureBox picScreenShot 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   375
      Left            =   120
      ScaleHeight     =   25
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   45
      TabIndex        =   5
      Top             =   5820
      Width           =   675
   End
   Begin VB.CommandButton cmdPrint 
      Caption         =   "Print"
      Height          =   435
      Left            =   4680
      TabIndex        =   2
      Top             =   3120
      Width           =   1350
   End
   Begin VB.CommandButton cmdEnd 
      Cancel          =   -1  'True
      Caption         =   "End"
      Height          =   435
      Left            =   6120
      TabIndex        =   3
      Top             =   3120
      Width           =   1350
   End
   Begin VB.TextBox txtDescription 
      Height          =   1095
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   1
      Top             =   1920
      Width           =   7335
   End
   Begin VB.Label lblApplication 
      Caption         =   "Fatal error in "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   120
      TabIndex        =   6
      Top             =   120
      Width           =   7305
   End
   Begin VB.Label lblErrorDescription 
      Height          =   915
      Left            =   120
      TabIndex        =   4
      Top             =   555
      Width           =   7305
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label2 
      Caption         =   "Please enter a description of the events leading to the error, then click the Print button:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   1680
      Width           =   6120
   End
End
Attribute VB_Name = "frmErrorDisplay"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mcolControlNameStack As Collection
Private mlngErrNumber        As Long
Private mstrErrDescription   As String
Private mstrErrSource        As String
Private mstrErrDate          As String
Private mstrErrTime          As String
Private mstrModule           As String
Private mstrRoutine          As String
Private mstrComputerName     As String
Private mstrUserName         As String
Private mstrControlNames     As String

Private mlngLeftMargin       As Long
Private mlngRightMargin      As Long
Private mlngRegion1          As Long
Private mlngRegion2          As Long
Private mlngRegion3          As Long

Private Const SRCCOPY        As Long = &HCC0020

Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function GetComputerName Lib "kernel32" Alias "GetComputerNameA" (ByVal lpBuffer As String, nSize As Long) As Long
Private Declare Function GetUserName Lib "advapi32.dll" Alias "GetUserNameA" (ByVal lpBuffer As String, nSize As Long) As Long


Public Sub ShowForm(ByRef rcolControlNameStack As Collection, _
                    ByVal vlngErrNumber As Long, _
                    ByVal vstrErrDescription As String, _
                    ByVal vstrErrSource As String, _
                    ByRef robjActiveForm As Object, _
                    ByVal vstrModule As String, _
                    ByVal vstrRoutine As String)
Dim i As Integer

    'Don't choke in the error handler.
    On Error Resume Next

    'Get time of error.
    mstrErrDate = Format$(Date, "mm-dd-yyyy")
    mstrErrTime = Format$(Time, "hh:mm:ss")
    
    Load Me
    
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
    
    'Capture the screen shot.
    If Not robjActiveForm Is Nothing Then
        If Not TypeOf robjActiveForm Is MDIForm Then
            robjActiveForm.AutoRedraw = False
            With picScreenShot
                .Height = robjActiveForm.ScaleHeight / Screen.TwipsPerPixelY
                .Width = robjActiveForm.ScaleWidth / Screen.TwipsPerPixelX
                BitBlt .hDC, 0, 0, .Width, .Height, robjActiveForm.hDC, 0, 0, SRCCOPY
            End With
        End If
    End If
    
    'Get error information.
    mlngErrNumber = vlngErrNumber
    mstrErrDescription = vstrErrDescription
    mstrErrSource = vstrErrSource
    mstrModule = vstrModule
    mstrRoutine = vstrRoutine
    Set mcolControlNameStack = rcolControlNameStack

    'Get other useful information.
    mstrComputerName = Space$(50)
    GetComputerName mstrComputerName, Len(mstrComputerName)
    mstrComputerName = RTrim$(mstrComputerName)
    
    If Len(mstrComputerName) > 1 Then
        mstrComputerName = Left$(mstrComputerName, Len(mstrComputerName) - 1)
    End If
    
    mstrUserName = Space$(50)
    GetUserName mstrUserName, Len(mstrUserName)
    mstrUserName = RTrim$(mstrUserName)
    
    If Len(mstrUserName) > 1 Then
        mstrUserName = Left$(mstrUserName, Len(mstrUserName) - 1)
    End If
    
    With mcolControlNameStack
        For i = 1 To .Count
            If Len(mstrControlNames) = 0 Then
                mstrControlNames = .Item(i)
            Else
                mstrControlNames = mstrControlNames & " -> " & .Item(i)
            End If
        Next i
    End With
    
    'Display error message.
    lblApplication.Caption = lblApplication.Caption & App.Title & ":"
    lblErrorDescription.Caption = "Error " & mlngErrNumber & ":  " & mstrErrDescription
    
    Me.Show vbModal
    
End Sub

Private Sub cmdEnd_Click()
    Unload Me
End Sub

Private Sub cmdPrint_Click()
Dim strComments As String

    'Don't choke in the error handler.
    On Error Resume Next
    
    cmdPrint.Enabled = False
    cmdEnd.Enabled = False
    Screen.MousePointer = vbHourglass
    
    With Printer
        .Orientation = vbPRORPortrait
        mlngLeftMargin = .TextWidth(String$(2, "M"))
        mlngRightMargin = .ScaleWidth - mlngLeftMargin
        mlngRegion1 = mlngLeftMargin + .TextWidth(String$(10, "M"))
        mlngRegion2 = mlngRegion1 + .TextWidth(String$(17, "M"))
        mlngRegion3 = mlngRegion2 + .TextWidth(String$(7, "M"))

        .FontName = "Arial"
        .FontBold = True
        .FontSize = 12
        .CurrentY = .TextHeight("M")
        PrintAtX mlngLeftMargin, App.Title & " Fatal Error"
        .FontName = "Times New Roman"
        .FontBold = False
        .FontItalic = False
        .FontSize = 10

        PrintAtX 0, ""
        PrintLine "Description:", mstrErrDescription
        PrintLine "Error:", CStr(mlngErrNumber)

        With App
            PrintLine "Application:", .Title, False
            PrintAtX mlngRegion2, "Version:", False
            PrintAtX mlngRegion3, .Major & "." & .Minor & "." & .Revision
        End With

        PrintLine "Date:", mstrErrDate, False
        PrintAtX mlngRegion2, "Time:", False
        PrintAtX mlngRegion3, mstrErrTime

        PrintLine "Computer:", mstrComputerName, False
        PrintAtX mlngRegion2, "User name:", False
        PrintAtX mlngRegion3, mstrUserName

        PrintLine "Module:", mstrModule, False
        PrintAtX mlngRegion2, "Routine:", False
        PrintAtX mlngRegion3, mstrRoutine

        PrintAtX 0, ""
        PrintLine "Control order:", mstrControlNames

        PrintAtX 0, ""
        PrintLine "Path:", mstrErrSource

        PrintAtX 0, ""
        strComments = Replace(txtDescription.Text, vbCrLf, " ")
        strComments = Trim$(strComments)
        If Len(strComments) = 0 Then
            strComments = "(None)"
        End If
        PrintLine "User comments:", strComments

        .PaintPicture picScreenShot.Image, mlngLeftMargin, .CurrentY + (2 * .TextHeight("M"))

        .EndDoc
    End With
    
    MsgBox "Error report printed on " & Printer.DeviceName
    
    cmdPrint.Enabled = True
    cmdEnd.Enabled = True
    Screen.MousePointer = vbDefault

End Sub

Private Sub PrintLine(ByRef rstrLabel As String, _
                      ByRef rstrDescription As String, _
                      Optional ByVal vblnNewLine As Boolean = True)
    
    'Don't choke in the error handler.
    On Error Resume Next

    PrintAtX mlngLeftMargin, rstrLabel, False
    PrintAtX mlngRegion1, rstrDescription, vblnNewLine

End Sub

Private Sub PrintAtX(ByVal vlngX As Long, _
                     ByVal vstrLine As String, _
                     Optional ByVal vblnNewLine As Boolean = True)
Dim strWord As String
Dim strLine As String
    
    'Don't choke in the error handler.
    On Error Resume Next

    With Printer
        If Len(vstrLine) = 0 Then
            .CurrentY = .CurrentY + (.TextHeight("M") * 0.5)
            Exit Sub
        End If

        strWord = GetWord(vstrLine)

        While Len(strWord) > 0
            If (vlngX + .TextWidth(strLine & strWord)) >= mlngRightMargin Then
                .CurrentX = vlngX
                Printer.Print strLine
                strLine = strWord
                strWord = ""
            Else
                strLine = strLine & strWord
            End If
            strWord = GetWord(vstrLine)
        Wend

        If Len(strLine) > 0 Then
            .CurrentX = vlngX
            If vblnNewLine Then
                Printer.Print strLine
            Else
                Printer.Print strLine;
            End If
        End If
    End With

End Sub

Private Function GetWord(ByRef rstrText As String) As String
Dim i As Long
    
    'Don't choke in the error handler.
    On Error Resume Next

    If Len(rstrText) = 0 Then
        GetWord = ""
    Else
        i = InStr(rstrText, " ")
        If i = 0 Then
            GetWord = rstrText
            rstrText = ""
        Else
            GetWord = Left$(rstrText, i)
            rstrText = Right$(rstrText, Len(rstrText) - i)
        End If
    End If

End Function

Private Sub cmdPrinterSetup_Click()
    On Error Resume Next
    dlgCommonDialog.ShowPrinter
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set frmErrorDisplay = Nothing
End Sub
